/****************************************************************************\
**  envType.hpp
**
**      envType.hpp supplies machine independent data types for 1, 2, 4, and
**	8 byte length integers, and 4 and 8 byte floating point types.  These types
**	should only be used when it is absolutely necessary to guarantee a byte
**	size (for a file format, for instance).  For other applications you should
**	probably just use int, or float.
**
**	Gigawatt Studios
**	Copyright(C) 2000 - All Rights Reserved
\****************************************************************************/

#ifdef ENV_TYPE_HPP
#error envType.hpp multiply included
#endif
#define ENV_TYPE_HPP

//#ifndef ENV_PLATFORM_HPP
//#include "envPlatform.hpp"
//#endif

namespace envType
{

	typedef char Int8;
	typedef unsigned char UInt8;
	typedef short Int16;
	typedef unsigned short UInt16;
	typedef int Int32;
	typedef unsigned int UInt32;
	typedef __int64 Int64;
	typedef unsigned __int64 UInt64;
	typedef float Float32;
	typedef double Float64;

}
